#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_VbecsWindowsUser : BaseTest
	{
		private VbecsWindowsUser _testUser;

		[SetUp]
		public void SetUp()
		{
			_testUser = (VbecsWindowsUser)(VbecsWindowsUser.GetVbecsUsers(false)[0]);			
		}

		[TearDown]
		public void TearDown()
		{
			_testUser = null;
		}

		[Test]
		public void DoesVbecsUsersGroupExist_Pass()
		{
			Assert.IsTrue( VbecsWindowsUser.DoesVbecsDomainGroupExist(true) );
			Assert.IsTrue( VbecsWindowsUser.DoesVbecsDomainGroupExist(false) );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.Untestable )]
		public void DoesVbecsUsersGroupExist_Fail() 
		{
			// It is unjustifiably time-consuming to set up a test deleting and re-creating Windows group. 
		}

		[Test]
		public void GetLocalVbecsUsers_Pass()
		{
			bool testUsersFound = false;
			IList _list = VbecsWindowsUser.GetVbecsUsers(false);
			
			Assert.IsNotNull( _list );
			Assert.IsTrue( _list.Count > 0 );
			Assert.IsTrue( _list[0] is VbecsWindowsUser );

			// CR2366
			// Note that this unit test requires that certain users are set up and added
			// to the group specified in the app.config file (VbecsUsersDomainGroupName).
			// These users have been created in Active Directory at this location: 
			// vha.domain.ext/VBECS/VBECS Users/CR2366 Users
			// -> CR2366,Test
			// -> CR2366, Test TC.
			// Note the lack of a space between first and last name.  This is what tests
			// the CR condition.
			foreach( VbecsWindowsUser _user in _list )
			{
                if (_user.LoginId.ToUpper().StartsWith("VHAISHVBECS24"))
				{
					testUsersFound = true;
					Assert.IsTrue(_user.FullName.ToUpper().StartsWith("TEST"));
				}
			}
			Assert.IsTrue(testUsersFound);
			// CR2366 end
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetLocalVbecsUsers_Fail() {}

		[Test]
		public void LoginId_Pass()
		{
			Assert.IsNotNull( _testUser.LoginId );
			Assert.IsTrue( _testUser.LoginId.Length > 0 );
			Assert.AreEqual( _testUser.LoginId.ToUpper(), _testUser.LoginId ); // making sure it's all caps string
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void LoginId_Fail(){}

		[Test]
		public void FullName_Pass()
		{
			string _test = _testUser.FullName;
			
			Assert.AreEqual(_test, this._testUser.FullName);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void FullName_Fail() {}

		[Test]
		public void ToString_Pass()
		{
			string _testString = _testUser.ToString();

			Assert.IsNotNull( _testString );
			Assert.IsTrue( _testString.Length > 0 );
			Assert.IsTrue( _testString.IndexOf( _testUser.LoginId ) != -1 );
			Assert.IsTrue( _testString.IndexOf( _testUser.FullName ) != -1 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void ToString_Fail() {}

		[Test]
		public void IsCurrentUserVbecsUser_Pass()
		{
			Assert.AreEqual(true, true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.Untestable )]
		public void IsCurrentUserInVbecsWindowsGroup_Fail() 
		{
			// while it's possible to add/remove user to/from group, a logoff/logon would 
			// be required to perform test. 
		}

		[Test]
		[Ignore( StandardIgnoreReasons.Untestable )]
		public void IsCurrentUserAdministrator_Pass()
		{
			//When unit tests are run by Nant, they run under vhaishsqlbb, which is an admin, but locally
			//this test could fail, so marking teh test UnTestable since results are not predicaTABLES.
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IsCurrentUserAdministrator_Fail() {}
	}
}

#endif
